#!/usr/local/bin/perl -w

# primer_invitrogen.pl
# Maureen Liu, Sanger Institute, Jul/2005
# based on parse_primers.pl
# Use Bioperl to process my CpG methylation assay primers
# Input: primers in fasta
# Output: primer list for invitrogen plate order form


# location of bioperl
use lib '/nfs/disk100/pubseq/PerlModules/Ensembl/www_38_1/bioperl-live';

use Bio::Seq;
use Bio::SeqIO;
use Bio::Tools::RestrictionEnzyme;

# input and output files===============================================

# Get the primer file
print "What's the primer file: "; 
$primer_file = <STDIN>;
chomp $primer_file;

# Output primer list for ordering
$primerA="invitrogen_primer_A.txt";
open (PRIMERA, ">$primerA") or die "Can't open output:$primerA\n";
$primerB="invitrogen_primer_B.txt";
open (PRIMERB, ">$primerB") or die "Can't open output:$primerB\n";

# primers for invitrogen===============================================

# get primer list
$primerIO = Bio::SeqIO->new(-file => $primer_file, 
                            -format => "fasta" );

# print primer list for invitrogen order form
while ($primer = $primerIO->next_seq) {   
  my $primer_id = $primer->display_id;
  my $primer_seq = $primer->seq;
  
  if ($primer_id =~ /[12]A/) {print PRIMERA $primer_id, "\t", $primer_seq,"\n";}
  if ($primer_id =~ /[12]B/) {print PRIMERB $primer_id, "\t", $primer_seq,"\n";}
  
}


exit;
